
#include "UnzipApp.h"
#include <Windows.h>
#include <stdio.h>


#include "zlib.h"
#include "../win/filetool.h"



#define dir_delimter '/'
#define MAX_FILENAME 512
#define READ_SIZE 8192

BOOL GetZipExtractName(const char * file , char * Newfile,char *ext)
{
	// Buffer to hold data read from the zip file.
    char read_buffer[ READ_SIZE ];
	
	unsigned int i;
	int error = UNZ_OK;
	unz_global_info global_info;
	size_t filename_length;
	unzFile zipfile;
	FILE *out;
	BOOL done;
	//const TCHAR *pExt2;
	//char pExt2[255];

	memset(&global_info, 0, sizeof(unz_global_info));

	//open zip
	zipfile = unzOpen(file);
    if ( zipfile == NULL ) return FALSE;

	//Get infos
    if ( unzGetGlobalInfo( zipfile, &global_info ) != UNZ_OK )
    {
        unzClose( zipfile );
        return FALSE;
    }
    
	// Loop to extract all files
	done = FALSE;
    for ( i = 0; i < global_info.number_entry; ++i )
    {
        // Get info about current file.
        unz_file_info file_info;
        char filename[ MAX_FILENAME ];

		memset(&file_info, 0, sizeof(unz_file_info));

        if ( unzGetCurrentFileInfo(zipfile , &file_info , filename , MAX_FILENAME, NULL, 0, NULL, 0 ) != UNZ_OK )
        {
            unzClose( zipfile );
            return FALSE;
        }

		//>>>>>>>>>>>>>>>>pExt2 = GetExtensionFromFilename(filename);
        // Check if this entry is not a directory and have good extension
        filename_length = strlen( filename );
        if (( filename[ filename_length-1 ] != dir_delimter ) && (1 == 1))//(strcmp(pExt2,ext) == 0))
        {
            // Entry is a file, so extract it.
            if ( unzOpenCurrentFile( zipfile ) != UNZ_OK )
            {
                unzClose( zipfile );
                return FALSE;
            }

            // Open a file to write out the data.
			GetTempPath(MAX_PATH,Newfile);
			strcat_s(Newfile,MAX_PATH,"\\");
			strcat_s(Newfile,MAX_PATH,filename);

            fopen_s( &out, Newfile, "wb" );
            if ( out == NULL )
            {
                unzCloseCurrentFile( zipfile );
                unzClose( zipfile );
                return FALSE;
            }

            do    
            {
                error = unzReadCurrentFile( zipfile, read_buffer, READ_SIZE );
                if ( error < 0 )
                {
                    printf( "error %d\n", error );
                    unzCloseCurrentFile( zipfile );
                    unzClose( zipfile );
                    return FALSE;
                }

                // Write data to file.
                if ( error > 0 )
                {
                    fwrite( read_buffer, error, 1, out ); // You should check return of fwrite...
                }
            } while ( error > 0 );

            fclose( out );
			done = TRUE;
        }

        unzCloseCurrentFile( zipfile );
		
		if (!done) {
			// Go the the next entry listed in the zip file.
			if ( ( i+1 ) < global_info.number_entry )
			{
				if ( unzGoToNextFile( zipfile ) != UNZ_OK )
				{
					unzClose( zipfile );
					return FALSE;
				}
			}
		}
		else i = global_info.number_entry;
		
    }

    unzClose( zipfile );

	return TRUE;
}